#!/bin/bash

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
#echo "Script is located in: $SCRIPT_DIR"

# Give the script permission to execute
sudo chmod +x $SCRIPT_DIR/restart

# Give the script permission to execute
sudo chmod +x $SCRIPT_DIR/svanlink

# Create the systemd service file
sudo bash -c "cat > /etc/systemd/system/svanlink.service <<EOF
[Unit]
Description=SvanLINK
After=network.target

[Service]
ExecStart=$SCRIPT_DIR/svanlink
WorkingDirectory=$SCRIPT_DIR
User=root
Group=root
KillMode=process

[Install]
WantedBy=multi-user.target
EOF"

# Reload systemd to read the new service file
sudo systemctl daemon-reload

# Enable the service to start on boot
sudo systemctl enable svanlink.service

# Start the service immediately
sudo systemctl start svanlink.service

sudo bash -c 'cat > /etc/xdg/autostart/svanlinkbrowser.desktop << EOF
[Desktop Entry]
Type=Application
Name=SvanLink Browser
Exec=firefox --kiosk --no-remote --profile /home/admin/kiosk-profile http://127.0.1.1/?presentationMode
X-GNOME-Autostart-enabled=true
EOF'
# Verify the service status
# sudo systemctl status svanlink.service