#!/bin/sh
heartbeat="/root/app/heartbeat"
dev=$(ps | grep rutapp | grep -v grep)
datenow=$(date)
if [[ "$dev" == "" ]]; then
  echo "$datenow No RutApp running - starting..."
  /root/app/start.sh
else
  new=$(date +%s)
  file=$(date +%s -r $heartbeat)
  count=$(($new - $file))
  if [[ "$count" -gt 300 ]]; then
    echo "$datenow RutApp not responding for $count seconds - restarting..."
    kill -9 $(ps | grep rutapp | grep -v grep | awk '{print $1}')
    sleep 5s
    /root/app/start.sh
  else
    echo "$datenow RutApp running correctly..."
  fi
fi
