#!/bin/sh
cd /root/app/cert
last_check=$(cat last_check 2>/dev/null) 
day_now=$(date '+%Y%m%d')
if [ "$last_check" == "$day_now" ]; then
  echo "$(date) Same day - skipping"
  exit 1
fi
echo "$day_now" > /root/app/cert/last_check
echo "$(date) Downloading CA certificate"
wget https://server1.svannet.com/downloads/packages/crt/stationsCA.crt
if [ ! -f /root/app/cert/stationsCA.crt ]; then
  echo "$(date) Failed to download new CA certificate!"
else
  diff=$(cmp -s stationsCA.crt ca.crt || echo "diff" )
  if [ "$diff" == "diff" ]; then
    if [ -f /root/app/cert/stationsCA_current.crt ]; then
      datenow=$(date '+%Y-%m-%d_%H%M%S')
      fname="stationsCA_$datenow.crt"
      echo "$(date) Moving ca.crt to $fname"
      mv ca.crt $fname
    fi
    echo "$(date) Adding new certificate"
#    certname="$(openssl x509 -hash -noout -in stationsCA.crt).0"
#    cp stationsCA.crt $certname
#    if [ -f $certname ]; then
#      mv stationsCA.crt stationsCA_current.crt
#    else
#     echo "($date) Failed to create $cername"
#    fi
    cp stationsCA.crt ca.crt
    echo "$(date) CA certificate changed!"
  else
    echo "$(date) CA certificate not changed!"
    rm stationsCA.crt
  fi
fi